//Name:WIniFile
//Description:Inifile operations class
//Version:0.9
//By: Maksim Orlovich
#include <stdio.h>
#include <string.h>
#include <iostream.h>

#ifndef w_string_macros
#define w_string_macros
#define S(x) &(x[0])
#endif

#ifndef w_errcodes
#define w_errcodes
#define WError 0
#define WOK 1
#endif

#ifndef w_ini
#define w_ini

class WIniKey
{
 public:
  WIniKey* next;
  char key[20];
  char value[80];
  WIniKey();
  ~WIniKey();
};

class WIniSection
{
 public:
  WIniKey  * keys;
  WIniSection  *next;
  char name[32];
  WIniSection();
  ~WIniSection();
};

class WIniFile
{
 private:
  char FName [250];
  WIniSection  *data;
  int LOADED;
  int AUTOSAVE;
  void _wini_add_section (char [250], WIniSection  *&,WIniKey  *&);
  void _wini_add_comment (char [250], WIniSection  *&,WIniKey  *&);
  void _wini_add_key (char [250], WIniSection  *&,WIniKey  *&);
  WIniKey* curpos;  

 public:
	 int GotoKey (const char *section,const char* key);
	 int AddFormating (const char* formating);
	 int AddComment(const char* comment);
	 void StripSectionFormating (const char* section);
	 void StripSectionComments(const char* section);
	 int DeleteKey (const char* section,const char* key);

  WIniFile ();
  WIniFile (const char *);
  int Read ();
  int Write ();
  int ReadKey (const char *,const char *,char*);
  int WriteKey (const char *,const char *,char*);
  int OpenFile (const char*);
  void CloseFile();
  void EnableAutoSave ();
  void DisableAutoSave ();
  int IsLoaded ();
  ~WIniFile ();
};



#endif
