//Name:WIniFile
//Description:.INI file operations class
//Version:0.9
//By: Maksim Orlovich

#define WINISCROUT cout
#include <fstream.h>
#include "wini.h"


WIniKey::WIniKey ()
{
 next=NULL;
}

WIniKey::~WIniKey ()
{
 if (next!=NULL)
  delete (next);
}

WIniSection::WIniSection ()
{
 keys=NULL;
 next=NULL;
}

WIniSection::~WIniSection ()
{
 if (next!=NULL)
  delete next;
 if (keys!=NULL)
  delete keys;
}

WIniFile::WIniFile ()
{
 LOADED=0;
 AUTOSAVE=0;
 data=NULL;
 curpos=NULL;
}

WIniFile::WIniFile (const char * filename)
{
 strcpy (FName,filename);
 data=NULL;
 AUTOSAVE=0;
 curpos=NULL;
 Read();
}

int WIniFile::OpenFile (const char* filename)
{
 CloseFile();
 strcpy (FName,filename);
 curpos=NULL;
 return Read();
}

void WIniFile::CloseFile ()
{
 if (LOADED==1)
 {
  if (AUTOSAVE==1)
   Write ();
  if (data!=NULL)
   delete (data);
  data=NULL;
  strcpy (FName,"\0");
  LOADED=0;
 };
 curpos=NULL;
}
 
int WIniFile::IsLoaded ()
{
 return LOADED;
}

WIniFile::~WIniFile ()
{
  if (LOADED==1)
   {
    CloseFile ();
    LOADED=0;
   }
}

int WIniFile::ReadKey (const char* section,const char* key,char* result)
{
 WIniSection  * cursect;
 WIniKey  * curkey;
 for (cursect=data;cursect!=NULL;cursect=cursect->next)
 {
  if (!stricmp (cursect->name,section))
  {
   for (curkey=cursect->keys;curkey!=NULL;curkey=curkey->next)
   {
    if (!stricmp (curkey->key,key))
    {
     strcpy (result,curkey->value);
     return WOK;
    }
   }
  }
 };
 return WError;
}
  
int WIniFile::Write()
{
 WIniSection* cursection;
 WIniKey* curkey=NULL;
 ofstream File (FName);
 if (!File)     {
					  LOADED=0;
					  return WError;
					 }

  else
  {
   LOADED=1;
   for (cursection=data;cursection!=NULL;cursection=cursection->next)
   {
    File<<"\n[";
    File<<S(cursection->name);
    File<<"]\n";
    for (curkey=cursection->keys;curkey!=NULL;curkey=curkey->next)
    {
     if (curkey->key[0]==';')
     {
      File<<";";
      File<<curkey->value;
      File<<"\n";
     }
     else
     {
      if (curkey->key[0]=='!')
      {
       File<<curkey->value;
       File<<"\n";
      }
      else
      {
       File<<curkey->key;
       File<<"=";
       File<<curkey->value;
       File<<"\n";
      }
     }
    }
   }

 };
 File.close();
 return WOK;
}

int WIniFile::Read()
{

 ifstream File (FName);
 char Buffer[250];

 WIniSection* cursection=NULL;
 WIniKey* curkey=NULL;


 if (!File)
 {
  LOADED=0;
  curpos=NULL;
  return WError;
 }
 else
 {
  LOADED=1;
  while (File)
   {
    File.getline (Buffer,250);
    if (Buffer[0]==';')
    {
     _wini_add_comment (Buffer,cursection,curkey);
    }
    else
    {
     if (Buffer[0]=='[')
       _wini_add_section (Buffer,cursection,curkey);
      else
       _wini_add_key (Buffer,cursection,curkey);
    }
   };
   File.close();
   curpos=NULL;
   return WOK;

  };
 curpos=NULL;
 return WError;

}

void WIniFile::_wini_add_section (char Buffer[250],WIniSection*& cursection,WIniKey*& curkey)
{
 char* SectDecode;
 if ((SectDecode=strrchr(S(Buffer),']'))!=NULL)
      *SectDecode='\0';
 if (cursection==NULL)
     {
      data=new (WIniSection);
      cursection=data;
      strcpy (S(cursection->name),S(Buffer)+1);
      curkey=NULL;
     }
     else
     {
      cursection->next=new (WIniSection);
      cursection=cursection->next;
      strcpy (S(cursection->name),S(Buffer)+1);
      curkey=NULL;
     };

}

void WIniFile::_wini_add_key (char Buffer[250] , WIniSection*& cursection,WIniKey*& curkey)
{
 char* EqPos,*KeyPos;
 if ( (EqPos=(strchr (S(Buffer),'=') ))!=NULL)
 {
  KeyPos=EqPos+1;
  *EqPos='\x0';
  if (cursection!=NULL)
  {
   if (curkey==NULL)
   {
     cursection->keys=new (WIniKey);
     curkey=cursection->keys;
     strcpy (curkey->key,S(Buffer));
     strcpy (curkey->value,KeyPos);
    }
   else
    {
     curkey->next=new (WIniKey);
     curkey=curkey->next;
     strcpy (curkey->key,S(Buffer));
     strcpy (curkey->value,KeyPos);
     }
   }
  }
 else
  {
    if (cursection!=NULL)
    {
     if (curkey==NULL)
     {
      cursection->keys=new (WIniKey);
      curkey=cursection->keys;
      strcpy (curkey->key,"!");
      strcpy (curkey->value,S(Buffer));
    }
   else
    {
     curkey->next=new (WIniKey);
     curkey=curkey->next;
     strcpy (curkey->key,"!");
     strcpy (curkey->value,S(Buffer));
     }
   }
  }
}


void WIniFile::_wini_add_comment (char Buffer[250] , WIniSection*& cursection,WIniKey*& curkey)
{
 if (cursection!=NULL)
 {
  if (curkey==NULL)
  {
   cursection->keys=new (WIniKey);
   curkey=cursection->keys;
   strcpy (curkey->key,";\0");
   strcpy (curkey->value,S(Buffer)+1);
  }
  else
  {
   curkey->next=new (WIniKey);
   curkey=curkey->next;
   strcpy (curkey->key,";\0");
   strcpy (curkey->value,S(Buffer)+1);
  }
 }
}

int WIniFile::WriteKey (const char* section,const char* key,char* result)
{
 curpos=NULL;
 WIniSection  * cursect,*oldcursect=NULL;
 WIniKey  * curkey,*oldcurkey=NULL;
 for (cursect=data;cursect!=NULL;cursect=cursect->next)
 {
  oldcursect=cursect;
  if (!stricmp (cursect->name,section))
  {
   //WINISCROUT<<"Section:"<<cursect->name<<"\n";
   for (curkey=cursect->keys;curkey!=NULL;curkey=curkey->next)
   {
	//WINISCROUT<<"Key:"<<curkey->key<<"="<<curkey->value<<"\n";
	oldcurkey=curkey;
    if (!stricmp (curkey->key,key))
    {
	 //WINISCROUT<<"Match\n";
     strcpy (curkey->value,result);
     return WOK;
    }
   }
   if (oldcursect->keys==NULL)
   {
	 //WINISCROUT<<"No key in section!";
     oldcursect->keys=new (WIniKey);
     curkey=oldcursect->keys;
     strcpy (curkey->key,S(key));
     strcpy (curkey->value,S(result));
	 return WOK;
   }
   else
   {
     oldcurkey->next=new (WIniKey);
     oldcurkey=oldcurkey->next;
     strcpy (oldcurkey->key,S(key));
     strcpy (oldcurkey->value,S(result));
	 return WOK;
   }
  }
 };

 //Done with section;
 if (data==NULL) //If no section at all
     {
      data=new (WIniSection);
      cursect=data;
      strcpy (S(cursect->name),S(section));
      
     }
     else
     {
      oldcursect->next=new (WIniSection);
      cursect=oldcursect->next;
      strcpy (S(cursect->name),S(section));      
     };
 oldcurkey=NULL;

 for (curkey=cursect->keys;curkey!=NULL;curkey=curkey->next)
 {
 //WINISCROUT<<"Key:"<<curkey->key<<"="<<curkey->value<<"\n";
  oldcurkey=curkey;
  if (!stricmp (curkey->key,key))
    {
	 //WINISCROUT <<"Match\n";
     strcpy (curkey->value,result);
     return WOK;
    }
 }

 if (oldcurkey==NULL)
 {
	 //WINISCROUT<<"No key in section!";
     cursect->keys=new (WIniKey);
     curkey=cursect->keys;
     strcpy (curkey->key,S(key));
     strcpy (curkey->value,S(result));
	 return WOK;
 }
   else
   {

     oldcurkey->next=new (WIniKey);
     oldcurkey=oldcurkey->next;
     strcpy (oldcurkey->key,S(key));
     strcpy (oldcurkey->value,S(result));
	 return WOK;
   }
 return WError;
}
  

void WIniFile::EnableAutoSave ()
{
 AUTOSAVE=1;
}

void WIniFile::DisableAutoSave ()
{
 AUTOSAVE=0;
}


int WIniFile::DeleteKey(const char * section, const char * key)
{
 curpos=NULL;
 WIniSection  * cursect;
 WIniKey  * curkey,*oldcurkey;
 for (cursect=data;cursect!=NULL;cursect=cursect->next)
 {
  if (!stricmp (cursect->name,section))
  {
   oldcurkey=NULL;
   for (curkey=cursect->keys;curkey!=NULL;curkey=curkey->next)
   {
    if (!stricmp (curkey->key,key))
    {
     if (oldcurkey==NULL)
	 {
		 cursect->keys=curkey->next;
		 curkey->next=NULL;
		 delete (curkey);
	 }
	 else
	 {
		 oldcurkey->next=curkey->next;
		 curkey->next=NULL;
		 delete (curkey);
	 }
     return WOK;
    }
	oldcurkey=curkey;
   }
  }
 };
 return WError;

}


void WIniFile::StripSectionComments(const char* section)
{
 int result;
 do
 {
	result=DeleteKey (section,";");
 }
 while (result==WOK);

}

void WIniFile::StripSectionFormating(const char * section)
{
 int result;
 do
 {
	result=DeleteKey (section,"!");
 }
 while (result==WOK);

}

int WIniFile::AddComment(const char* comment)
{
 WIniKey* comkey=new (WIniKey);
 if (curpos!=NULL)
 {
	comkey->next=curpos->next;
	strcpy (comkey->key,";");
	strcpy (comkey->value,comment);
	curpos->next=comkey;
	curpos=comkey;
	return WOK;
 };
 return WError;
}


int WIniFile::AddFormating(const char * formating)
{
 WIniKey* comkey=new (WIniKey);
 if (curpos!=NULL)
 {
	comkey->next=curpos->next;
	strcpy (comkey->key,"!");
	strcpy (comkey->value,formating);
	curpos->next=comkey;
	curpos=comkey;
	return WOK;
 };
 return WError;
}

int WIniFile::GotoKey(const char * section, const char * key)
{
 curpos=NULL;
 WIniSection  * cursect;
 WIniKey  * curkey;
 curpos=NULL;

 for (cursect=data;cursect!=NULL;cursect=cursect->next)
 {
  if (!stricmp (cursect->name,section))
  {
   for (curkey=cursect->keys;curkey!=NULL;curkey=curkey->next)
   {
    if (!stricmp (curkey->key,key))
    {
     curpos=curkey;
     return WOK;
    }
   }
  }
 };
 return WError;

}
