
BITS 32

GLOBAL	_vbeDetect__Fv		
GLOBAL	_vbeGetModeInfo__Fi
GLOBAL	_vbeOpen__Fiii
GLOBAL  _vbeClose__Fv
GLOBAL  _vbeSetScanWidth__Fi
GLOBAL	_vbeGetScanWidth__Fv
GLOBAL	_vbeGetStart__Fv
GLOBAL	_vbeSetStart__Fii
GLOBAL  _vbeBlit__Fv

SECTION .bss


struc VBEINFOBLOCK

VbeSignature        	resd    1     	; VBE Signature
VbeVersion          	resw	1      	; VBE Version
OemStringPtr        	resd	1  	; Pointer to OEM String
Capabilities        	resd 	1     	; Capabilities of graphics cont.
VideoModePtr        	resd    1    	; Pointer to Video Mode List
TotalMemory         	resw 	1	; Number of 64kb memory blocks

	; Added for VBE 2.0

OemSoftwareRev      	resw	1	; VBE implementation Software revision
OemVendorNamePtr    	resd    1      	; Pointer to Vendor Name String
OemProductNamePtr   	resd    1	; Pointer to Product Name String
OemProductRevPtr    	resd 	1	; Pointer to Product Revision String
Reserved          	resb   	222   	; Reserved for VBE implementation

	; scratch area

OemData             resb   256		; Data Area for OEM Strings

endstruc


struc MODEINFOBLOCK

	; Mandatory information for all VBE revisions:

ModeAttributes      resw 1        ; mode attributes
WinAAttributes      resb 1        ; window A attributes
WinBAttributes      resb 1        ; window B attributes
WinGranularity      resw 1        ; window granularity
WinSize             resw 1        ; window size
WinASegment         resw 1        ; window A start segment
WinBSegment         resw 1        ; window B start segment
WinFuncPtr          resd 1        ; pointer to window function
BytesPerScanLine    resw 1        ; bytes per scan line

	; Mandatory information for VBE 1.2 and above:

XResolution         resw 1        ; horizontal resolution in pixels or chars
YResolution         resw 1        ; vertical resolution in pixels or chars
XCharSize           resb 1        ; character cell width in pixels
YCharSize           resb 1        ; character cell height in pixels
NumberOfPlanes      resb 1        ; number of memory planes
BitsPerPixel        resb 1        ; bits per pixel
NumberOfBanks       resb 1        ; number of banks
MemoryModel         resb 1        ; memory model type
BankSize            resb 1        ; bank size in KB
NumberOfImagePages  resb 1        ; number of images
_Reserved           resb 1        ; reserved for page function

	; Direct Color fields (required for direct/6 and YUV/7 memory models)

RedMaskSize         resb 1        ; size of direct color red mask in bits
RedFieldPosition    resb 1        ; bit position of lsb of red mask
GreenMaskSize       resb 1        ; size of direct color green mask in bits
GreenFieldPosition  resb 1        ; bit position of lsb of green mask
BlueMaskSize        resb 1        ; size of direct color blue mask in bits
BlueFieldPosition   resb 1        ; bit position of lsb of blue mask
RsvdMaskSize        resb 1        ; size of direct color reserved mask in bits
RsvdFieldPosition   resb 1        ; bit position of lsb of reserved mask
DirectColorModeInfo resb 1        ; direct color mode attributes

	; Mandatory information for VBE 2.0 and above:

PhysBasePtr         resd 1        ; physical address for flat frame buffer
OffScreenMemOffset  resd 1        ; pointer to start of off screen memory
OffScreenMemSize    resw 1        ; amount of off screen memory in 1k units
__Reserved          resb 206 

endstruc

struc VBESURFACE	

mode			resd	1	; VBE mode number
width			resd	1
height			resd	1	; visible screen size
bitdepth		resd	1	; no. of bits per pixel
depth			resd	1	; no. of bytes per pixel
lfbselector		resd	1
lfbptr			resd	1
granularity		resd	1

scanwidth		resd	1
bytewidth		resd	1	; scanwidth * depth
screensize		resd	1
screenstatus		resd	1
screenstart		resd	1
buffer			resd	1

endstruc


ALIGN 4
vbeInfo	resb 512		;protected mode store for vbe info

ALIGN 4
vbeModeInfo resb 256

ALIGN 4
vbeSurface resd 30


ALIGN 4
returncode	resd 	1
vbeMode		resd	1
vbeScreenWidth	resd	1
vbeScreenHeight	resd	1
vbeScreenBits	resd	1
vbeLfbPtr	resd	1
vbeLfbSelector  resd	1
vbeTempVar	resd	1

dosmem_segment	resd	1
dosmem_selector	resd	1


ALIGN 4
ModeBuf	resb	1024		;enough for 512 screen modes...
					;could be reduced.
ModeBufEnd	resd	1


ALIGN 4
struc realmoderegisters
	rm_edi	  	resd	1
	rm_esi		resd	1
	rm_ebp		resd	1
	rm_esp		resd	1
	rm_ebx		resd	1
	rm_edx		resd	1
	rm_ecx		resd	1
	rm_eax		resd	1

	rm_flags	resw	1
	rm_es		resw	1
	rm_ds		resw	1
	rm_fs		resw	1
	rm_gs		resw	1
	rm_ip		resw	1
	rm_cs		resw	1
	rm_sp		resw	1
	rm_ss		resw	1
	rm_spare_data	resd	20
endstruc


RMREGS resd 33


SECTION .data
ALIGN 4
vbeInit		dd	0
vbeInfoInit	dd	0


SECTION .text


keypress:

	mov ax, 0
	int 16h

	ret


;***********************************************************************

vbeDosMemOpen:

	mov	eax, 0100h
	mov	ebx, 512/16		;allocate 512 bytes of RM memory
	int	31h
	mov	[dosmem_segment], eax
	mov	[dosmem_selector], edx		;PM selector...	
	mov	ebx, 0
	jc vbeDosMemOpen_error

	mov 	ebx, -1

vbeDosMemOpen_error:

	mov 	dword [returncode], ebx
	ret

;***********************************************************************

vbeDosMemClose:

	mov	eax, 0101h			; free dos memory buffer
	mov	edx, [dosmem_selector]
	int	031h
	ret


;***********************************************************************

vbeGetInfo:

	; Request VBE 2.0 info, save fs

	push fs
	mov eax, [dosmem_selector]
	mov fs, ax
	mov dword [fs:VbeSignature], '2EBV'	; Not strictly necessary?


	; Get the VBE infomation block

	mov     edi, RMREGS				;es:edi points to RMREGS
	mov     dword [RMREGS+rm_eax], 04f00h		;vesa code	
	mov	ax, [dosmem_segment]
	mov     [RMREGS+rm_es], ax			;
	mov     dword [RMREGS+rm_edi], 0		;es:di points to RM block
	mov     ax, 0300h			; simulate real mode int
	mov     bx, 010h			;clear bh, int required in bl
	mov 	cx, 0
	int     031h
	mov	ebx, 1
	jc	NEAR vbeGetInfo_error				; DPMI error

	mov	eax, [RMREGS+rm_eax]
	cmp     al, 04fh			; test for vbe code
	mov	ebx, 2
	jne	NEAR vbeGetInfo_error				; vbe not detected

	cmp 	dword [fs:VbeSignature], 'VESA'
	mov	ebx, 3
	jne	NEAR vbeGetInfo_error				; Not VESA!


	; Copy the block into protected mode memory

	mov	edi, vbeInfo
	mov	ecx, VBEINFOBLOCK_size
	mov 	esi, 0

	push ds
	push fs
	pop ds		;set ds to real mode selector
	cld
	rep	movsb			
	pop ds		

	mov	dword [vbeInfoInit], 1
	mov 	ebx, -1

vbeGetInfo_error:

	pop fs
	mov 	[returncode], ebx
	ret	


;*******************************************************************

vbeGetModeList:

	; Copy needed information into a local buffer
	; and fix up the addresses in the vbeInfo block

	mov	ebp, vbeInfo		; pmode vbeinfo block
	mov	edi, ModeBuf		; Mode number buffer


	; Segment to descriptor for VideoModePtr

	mov ebx, [ebp+VideoModePtr]  
	shr ebx, 16 		; ebx = high part of far ptr
	mov eax, 02h
	int 31h
	mov ebx, 4
	jc NEAR vbeGetModeList_error


	; Copy the mode list
	
	mov esi, [ebp+VideoModePtr]
	and esi, 0ffffh 	; esi = low part of far ptr	

	push ds
	mov 	ds, ax
vbeGetInfo_p1:
	lodsw
	cmp	ax, -1				; end of list
	je	vbeGetInfo_p2
	stosw
	jmp	vbeGetInfo_p1
vbeGetInfo_p2:
	stosw                                   ; terminate list
	pop ds


	; Set video mode list pointer to localBuf

	mov dword [vbeInfo+VideoModePtr], ModeBuf

	; Check if we over-ran the local buffer

	cmp	edi, ModeBufEnd
	mov	ebx, 5
	jge	vbeGetModeList_error

	mov	ebx, -1
	
vbeGetModeList_error:

	mov	dword [returncode], ebx
	ret


;********************************************************************

vbeGetModeBlock:

	pushad

	; Check for vbeInfo block

	cmp	dword [vbeInfoInit], 0
	mov	ebx, 6	
	jz 	NEAR vbeGetModeBlock_error	

	; Set FS to dosmem selector

	push fs
	mov	eax, [dosmem_selector]
	mov	fs, ax

	; Get the VBE mode infomation block

	mov	eax, [vbeMode]
	mov     edi, RMREGS
	mov     [RMREGS+rm_eax], dword 04f01h		;get mode info
	mov	[RMREGS+rm_ebx], dword 0
	mov     [RMREGS+rm_ecx], eax
	mov	ax, [dosmem_segment]
	mov	[RMREGS+rm_es], ax
	mov     [RMREGS+rm_edi], dword 0

	mov     ax, 0300h			; simulate real mode int
	mov     bx, 010h
	mov     cx, 0
	int     031h
	mov	ebx, 7
	jc	NEAR vbeGetModeBlock_error		; DPMI error
	
	mov	eax, [RMREGS+rm_eax]
	cmp     al,04fh
	mov	ebx, 8
	jne	NEAR vbeGetModeBlock_error		; vbe not detected

	; Copy block to vbeModeInfo structure

	push ds
	push fs
	pop ds
	mov	edi, vbeModeInfo
	mov	esi, 0
	mov	ecx, MODEINFOBLOCK_size
	rep	movsb
	pop ds	

	mov	ebx, -1

vbeGetModeBlock_error:

	pop fs
	mov	[returncode], ebx	
	popad
	ret


;
; vbeDetect
; Detect and get VBE info
;
; In:
;
; Out:
;    EAX - pointer to vbeInfo structure
;    or error code on failure
;
;

_vbeDetect__Fv:

	push	ebp
	mov	ebp, esp
	mov	eax, [ebp+8]
	mov	[vbeTempVar], eax

	pushad

	; Allocate dos memory block

	call 	vbeDosMemOpen
	cmp 	dword [returncode], -1
	jnz vbeDetect_error

	; Get vbeInfo structure
	
	call	vbeGetInfo
	cmp	dword [returncode], -1
	jnz vbeDetect_error

	; Get mode list and set videoModePtr

	call	vbeGetModeList
	cmp	dword [returncode], -1
	jnz vbeDetect_error

	; Release DOS memory then return pointer to vbeInfo struct

	mov	dword [returncode], vbeInfo

vbeDetect_error:
	
	call	vbeDosMemClose
	popad
	pop ebp
	mov 	eax, [returncode]
	ret


;
; vbeGetModeInfo
; Find information on a video mode
;
; In:
;   Mode number
;
; Out:
;    Returns pointer to VBEMODEINFO structure.
;    or error code for failure.
;
;

_vbeGetModeInfo__Fi:

	; Save mode number

	push ebp
	mov 	ebp, esp
	mov	eax, [ebp+8]
	mov	[vbeMode], eax

	pushad

	; Open dos memory block

	call	vbeDosMemOpen	
	cmp	dword [returncode], -1
	jnz vbeGetModeInfo_error

	; Get the VBE mode infomation block

	call	vbeGetModeBlock
	cmp	dword [returncode], -1
	jnz 	vbeGetModeInfo_error

	; return pointer to mode info structure

	mov	dword [returncode], vbeModeInfo


vbeGetModeInfo_error:

	call	vbeDosMemClose
	popad
	pop ebp
	mov	eax, [returncode]
	ret



;
; vbeOpen
; Setup up a video mode
;
; In:
;   X res, Y res, Colour depth in stack
;
; Out:
;    EAX - returns pointer to a VBESURFACE structure,
;          or error code on failure
;
;

_vbeOpen__Fiii

	; Save requested mode info

	push ebp
	mov ebp,esp

	mov 	eax, [ebp+8]
	mov 	dword [vbeScreenWidth], eax
	mov 	eax, [ebp+12]
	mov 	dword [vbeScreenHeight], eax
	mov 	eax, [ebp+16]
	mov 	dword [vbeScreenBits], eax

	pushad


	; Allocate dos memory buffer

	call	vbeDosMemOpen	
	cmp	dword [returncode], -1
	jnz 	NEAR vbeOpen_error

	; Check we're not already open

	cmp	[vbeInit], dword 1
	mov 	dword [returncode], 9
	jz	NEAR vbeOpen_error


	; Scan mode list for the mode

	mov 	eax, 0
	mov	edi, vbeModeInfo
	mov 	esi, ModeBuf-2		;point to mode number buffer

vbeOpen_p1:
	add 	esi, 2
	mov 	ax, [esi]
	cmp	ax, -1                  	; End of list
	jne	vbeOpen_p2	
	mov 	dword [returncode], 10
	jmp 	vbeOpen_error		; No matching mode found
vbeOpen_p2:
	mov	[vbeMode], ax			; Save mode number

	call vbeGetModeBlock
	cmp	dword [returncode], -1
	jnz	NEAR vbeOpen_error

	; Check this is the mode we want

	movzx   eax, word [edi+XResolution]
	cmp     eax, [vbeScreenWidth]
	jnz	NEAR vbeOpen_p1
	movzx	eax, word [edi+YResolution]
	cmp	eax, [vbeScreenHeight]
	jnz	NEAR vbeOpen_p1
	mov	al, [edi+BitsPerPixel]
	cmp	al, [vbeScreenBits]
	jnz	NEAR vbeOpen_p1
	mov	al, [edi+GreenMaskSize]
	cmp	al, 6
	jnz	NEAR vbeOpen_p1


	; This is our mode, try setting it with LFB on

	mov	ax, 04f02h
	mov    	bx, [vbeMode]
	or	bx, 04000h			; ask for LFB
	int	010h
	cmp	ah, 0
	mov 	dword [returncode], 11
	jnz	NEAR vbeOpen12


	; Map LFB memory

	mov     ebx, [edi+PhysBasePtr]
	mov     ecx, ebx
	shr     ebx, 16                 ; BX:CX = physical base ptr
	mov     esi, [vbeInfo+TotalMemory]	; 64kb blocks... 
	mov	edi, 0				; SI:DI = region size
	mov     ax, 0800h
	int     031h

	shl     ebx, 16
	mov     bx, cx			; linear address in ebx
	mov     [vbeLfbPtr], ebx  	; Save LFB pointer
	mov 	dword [returncode], 12
	jc	NEAR vbeOpen_error	; DPMI error

        mov     dword [vbeInit], 1

	; Create a selector
	
	mov 	eax, 0
	mov	ecx, 1		; Allocate a descriptor 
	int	31h
	mov	[vbeLfbSelector], eax
	mov 	dword [returncode], 13
	jc	NEAR vbeOpen_error

	mov	ebx, [vbeLfbSelector]	
	mov	edx, [vbeLfbPtr]
	mov	ecx, [vbeLfbPtr]
	shr	ecx, 16
	mov	eax, 7
	int	31h			; set selector base		
	mov 	dword [returncode], 14
	jc	NEAR vbeOpen_error

	mov	ebx, [vbeLfbSelector]
	mov	ecx, [vbeInfo+TotalMemory]
	shl	ecx, 16
	sub	ecx, 1
	mov	edx, ecx
	shr	ecx, 16
	mov     eax, 8	
	int	31h			; and selector limit
	mov 	dword [returncode], 15
	jc	NEAR vbeOpen_error

	mov	dword [vbeSurface+granularity], 0
	mov	dword [vbeSurface+lfbptr], 1

	jmp vbeOpen_OK


vbeOpen12:

	; Set granularity & flag

	mov	dword [vbeSurface+lfbptr], 0

	xor	eax, eax
	mov	ax, [vbeModeInfo+WinGranularity]
	mov	[vbeSurface+granularity], eax	

	; Check attributes of window A

	mov	al, [vbeModeInfo+WinAAttributes]
	and	al, 7
	cmp	al, 5			; Need window A writable & supported
	mov	dword [returncode], 11
	jl	NEAR vbeOpen_error

	; Open non-lfb mode

	mov	ax, 04f02h
	mov    	bx, [vbeMode]
	int	010h
	cmp	ah, 0
	mov 	dword [returncode], 16
	jnz	NEAR vbeOpen_error
	

	; Find PM selector for WinASegment

	mov	bx, [vbeModeInfo+WinASegment]
	mov	eax, 2
	int	31h
	mov	dword [returncode], 17
	jc	NEAR vbeOpen_error

	and	eax, 0ffffh	
	mov	[vbeLfbSelector], eax	


vbeOpen_OK:

	; Set scan line width to be sure

	mov	ecx, [vbeScreenWidth]
	mov     eax, 04f06h
	xor     ebx, ebx
	xor     edx, edx
	int     010h

	; And get scanwidth...

	mov     eax, 04f06h
	mov     ebx, 1
	xor	ecx, ecx
	int     010h

	mov	[vbeSurface+bytewidth], ebx	; get width in bytes
	mov	[vbeSurface+scanwidth], ecx	; get width in pixels
	
	; Set init

	mov	[vbeInit], dword 1

	; build the vbe surface structure

	mov	edi, vbeSurface

	xor	eax, eax
	mov	ax, [vbeMode]
	mov	[edi+mode], eax

	mov	eax, [vbeScreenWidth]
	mov	[edi+width], eax
	mov	eax, [vbeScreenHeight]
	mov	[edi+height], eax

	mov	eax, [vbeScreenBits]
	mov	[edi+bitdepth], eax
	shr	eax, 3
	mov	[edi+depth], eax

	mov	eax, [vbeLfbSelector]
	and	eax, 0ffffh
	mov	[edi+lfbselector], eax

	
	; Return vbeSurface pointer to calling program

	mov	dword [returncode], vbeSurface

	push es

	mov	eax, [vbeLfbSelector]
	mov	es, ax
	mov	word [es:0], 63488

	pop es


vbeOpen_error:			

	call vbeDosMemClose	

	popad
	pop ebp
	mov	eax, [returncode]
	ret








;
; vbeClose
; Close the driver and return to mode 3h
;
; In:
;   NONE
;
; Out:
;   NONE
;
;

_vbeClose__Fv

	pushad

	; Check we're open

	cmp	[vbeInit], dword 0
	je	vbeClose12

	cmp	dword [vbeSurface+lfbptr], 0
	jz vbeClose12			; Skip for VBE 1.2

	; Release LFB mapping

	mov     ax, 0801h
	mov     ebx, [vbeLfbPtr]
	mov     ecx, ebx
	shr     ebx, 16
	int     031h            ; release mapping

vbeClose12:

	; Reset video mode

	mov	eax, 03h
	int	010h

	mov	[vbeInit], dword 0

vbeclose_END:
	popad
	ret


;
; vbeSetStart
; Set new display start position
; ********Does not wait for vr.**********
;
; In:
;   new x position
;   new y position
;
; Out:
;    Returns 1, new display position set.
;    Otherwise returns 0 for failure.
;
;

_vbeSetStart_Fii

	push ebx
	push ecx
	push edx
	push ebp		
	
	mov	ebp, esp
	mov	ecx, [ebp+20]		;ypos
	mov	edx, [ebp+24]		;xpos

	mov     eax, 04f07h
	mov	ebx, 00h			;wait for vertical retrace
	int     010h

	cmp     al, 04fh
	jne	vbesetdisp_error		; vbe not detected

	mov	eax, 1
	pop ebp
	pop edx
	pop ecx
	pop ebx
	ret

vbesetdisp_error:

	mov	eax, 0
	pop ebp
	pop edx
	pop ecx
	pop ebx
	ret



;
; vbeGetStart
; Get the display start position
;
; In:
;    Nothing
;
; Out:
;    Returns 1, if x and y data was set.
;    Otherwise returns 0 for failure.
;    Modifies ScreenInfo structure
;
;
_vbeGetStart_Fi

	push ebx
	push ecx
	push edx
	
	mov     eax, 04f07h
	mov     ebx, 1
	xor	edx,edx
	xor	ecx,ecx
	int     010h

	cmp     al,04fh
	jne	vbegetdisp_error		; vbe not detected

	push ebp
	mov	ebp, esp

	and	edx, 0ffffh
	and	ecx, 0ffffh 
	mov	eax, [vbeSurface+bytewidth]
	mul	edx		; Multiply bytewidth by Y	
	shl	ecx, 1
	add	eax, ecx	; add X
	mov	[vbeSurface+screenstart], eax

	mov	eax,1
	
	pop ebp	
	pop edx
	pop ecx
	pop ebx
	ret

vbegetdisp_error:

	mov	eax, 0
	pop edx
	pop ecx
 	pop ebx
	ret


;
; vbeSetScanWidth
; Set pixels per scan line of the display
;
; In:
;   Pixels per scan line
;
; Out:
;    Returns 1, new pixels per scan line set.
;    Otherwise returns 0 for failure.
;
;
_vbeSetScanWidth

	push ebx
	push ecx
	push edx
	push ebp
	
	mov	ebp, esp
	mov	ecx, [ebp+20]

	mov     eax, 04f06h
	xor     ebx, ebx		; set width in *pixels*
	xor     edx, edx
	int     010h

	cmp     al,04fh
	jne	vbesetscan_error		; vbe not detected

	mov	eax, [ebp+20]
	pop ebp
	pop edx
	pop ecx
	pop ebx
	ret

vbesetscan_error:

	mov	eax,0
	pop ebp
	pop edx
	pop ecx
	pop ebx
	ret




;
; vbeGetScanWidth
; Get number of pixels per scan line
;
; In:
;   NONE
;
; Out:
;    Returns 1 for success, or 0 for failure.
;    Bytewidth and scanwidth in vbeSurface	
;
;

_vbeGetScanWidth

	push ebx 
	push ecx
	push edx

	mov     eax, 04f06h
	mov     ebx, 1
	xor	ecx, ecx
	int     010h

	cmp     al,04fh
	jne	vbegetline_error		; vbe not detected

	mov	[vbeSurface+bytewidth], ebx	; get width in bytes
	mov	[vbeSurface+scanwidth], ecx	; get width in pixels
	mov	eax, 1
	pop edx
	pop ecx
	pop ebx
	ret

vbegetline_error:

	mov	eax, 0
	pop edx
	pop ecx
	pop ebx
	ret


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;  vbeBlit
;  Blits buffer to screen and clears buffer to black
;
;  In:
;    None
;  Out:
;    Screen only
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
_vbeBlit__Fv

	cmp	dword [vbeInit], 1
	jz	NEAR vbeBlit_p2
	ret

vbeBlit_p2

	pushad

	cmp	dword [vbeSurface+lfbptr], 0
	jz	vbeBlit12

	mov	esi, [vbeSurface+buffer]
	mov	edi, 0
	
	mov	ax, es
	push eax
	mov	eax, [vbeSurface+lfbselector]
	mov	es, ax

	mov	edx, [vbeSurface+screensize]
	shr	edx, 2
	cld
	mov	eax, 0


    	outerloop3: 		; Blitting bit	

		mov	ecx, 128
		rep movsd
		sub	esi, 512
		mov	ecx, 128
	
		innerloop3: 		; Buffer clearing bit
   
			mov	[esi], eax
			mov	[esi+4], eax
			mov	[esi+8], eax
			mov	[esi+12], eax
			mov	[esi+16], eax
			mov	[esi+20], eax
			mov	[esi+24], eax
			mov	[esi+28], eax	

			add	esi, 32
			sub	ecx, 8	 
			jnz innerloop3

		sub	edx, 128
		jnz	outerloop3

	pop eax
	mov	es, ax
	popad
	ret

vbeBlit12:

        mov eax, 04f05h
        mov ebx, 0
        mov edx, 0
        int 10h                 ; Window A position zero

	mov bx, es
	push ebx 		; Save es

	mov 	esi, [vbeSurface+buffer] 	; Load esi with buffer pointer
	mov 	eax, [vbeSurface+lfbselector]
    	mov 	es, ax 			; Load es with window selector
	cld			

	mov 	ecx, [vbeSurface+screensize]		
	mov 	eax, ecx	; Screen size in bytes in eax & ecx 	
	and 	ecx, 0ffffh	; 
	shr 	ecx, 2		
    	shr	eax, 16 	; no. of full screens in eax
	push ecx 		; Store remaining dwords

   
vbeBlit_p1		; Done once per 64K window

	push eax
	mov	edi, 0
	mov	ebx, 16384
	mov	eax, 0

    	outerloop:		; Blitting bit	

		mov	ecx, 128
		rep movsd  
		sub	esi, 512
		mov	ecx, 128

		innerloop: 		; Buffer clearing bit

			mov	[esi], eax
			mov	[esi+4], eax
			mov	[esi+8], eax
			mov	[esi+12], eax
			mov	[esi+16], eax
			mov	[esi+20], eax
			mov	[esi+24], eax
			mov	[esi+28], eax

			add	esi, 32
			sub	ecx, 8
			jnz	innerloop

		sub	ebx, 128
		jnz	outerloop

        mov     eax, 04f05h
        mov     ebx, 0
        add     edx, [vbeSurface+granularity]
        int     10h

        pop eax
	sub	eax, 1
	jnz	NEAR vbeBlit_p1

	pop ebx
	mov 	edi, 0

	outerloop2:

		mov	eax, 0
		mov	ecx, 128
		rep movsd
		sub	esi, 512
		mov	ecx, 128

		innerloop2:

			mov	[esi], eax
			mov	[esi+4], eax
			mov	[esi+8], eax
			mov	[esi+12], eax
			mov	[esi+16], eax
			mov	[esi+20], eax
			mov	[esi+24], eax
			mov	[esi+28], eax

			add	esi, 32
			sub	ecx, 8
			jnz	innerloop2

		sub	ebx, 128
		jnz	outerloop2
 

	pop ebx
	mov	es, bx	
	popad
	ret

vbeBlit_error

	pop ebx
	mov	es, bx
	popad
	ret	
