#include "tep3d.h"

#define degrees 1024	// Degrees in circle
#define SI (TEP.Graph.ScreenInfo)

class TepServices
{
private:

  OBJECT* object[1024];
  int NumObjects;
  FARLIGHT* farlight[32];
  int NumfarLights;
  PTLIGHT* ptlight[32];
  int NumptLights;
  CAMERA camera;

  float sint[degrees];
  float cost[degrees];

  float FindInvCos( float, float );
  void FindScreenAngles();  
  void SinCos();
  void FindMat( int, int, int, Matrix );

public:

  void Init();			//Initializes
  void PostGraphInit();		
  void Cleanup();		//Cleanup

  void MoveObjects();
  void AIDecision();
  void Draw3dScene();

  int AddObject( int, int, int, double, double, double );
  void RemoveObject(int);
  int AddfarLight( int, int, int, float, float, float );
  void RemovefarLight(int);
  int AddptLight( double, double, double, float, float, float );
  void RemoveptLight(int);
};