#include "tepcore.h"
#include "tepinln.h"

#define RET { printf("Quit on line %d\n",__LINE__); return; }


void TepServices::Init()
{
  int i;
  cout<<"Initializing services...\n";

  printf("Creating sine/cosine tables with %i degrees in a circle...\n", degrees );
  SinCos();

  for( i=1; i<1024; i++) object[i] = 0; 	// Making absolutely sure...

  printf("Attempting to add an object or two...\n");

  i = AddObject( 0,0,0,0,0,300 );
  printf("Object %i: %i points at base %x, %i polys at base %x\n", i,
	object[i]->NumPoints, (int)object[i]->BasePoints,
	object[i]->NumPolys, (int)object[i]->BasePolys );
  printf("Total objects = %i\n", NumObjects );

  FindMat(0,0,0,camera.cam_m);

}


void TepServices::PostGraphInit()
{
  SI->screenD = (SI->screenX) / 2;
  SI->offsetX = (SI->screenX) / 2;
  SI->offsetY = (SI->screenY) / 2;
  
  FindScreenAngles();
}


void TepServices::Cleanup()
{
  int i;
  for( i=0; i<NumObjects; i++ ) delete object[i];
}

int TepServices::AddObject( int X, int Y, int Z, double x, double y, double z )
{
  POINT* pointptr;
  POLY* polyptr;
  int i = NumObjects;
  int j;

  //printf("Enter filename of .asc file: \n");
  //scanf("%s", fname);
char fname[20] = "gsphere.asc";		//******** Temp

  object[i] = new OBJECT(fname);

  // Setup object variables

  FindMat( X,Y,Z, object[i]->glob_m );	// Changed depending on input...
  FindMat( 0,0,0, object[i]->angvel_m );
  object[i]->pos_v[0] = x;
  object[i]->pos_v[1] = y;
  object[i]->pos_v[2] = z;
  for( j=0; j<3; j++ ) object[i]->vel_v[j] = 0;
  
  NumObjects++;
  return(i);
}

void TepServices::RemoveObject(int i)
{
  if(object[i] == NULL) return; 

  delete object[i];		// should set objects[i]=NULL

  object[i] = object[NumObjects-1];
  object[NumObjects-1] = NULL;  
  NumObjects--;
}

int TepServices::AddfarLight( int X, int Y, int Z, float red, float green, float blue )
{
  int i = NumfarLights;
  int j;
  Matrix temp;
  Vector vtemp;

  farlight[i] = new FARLIGHT;

  // Setup object variables

  farlight[i]->light_v[0] = 0;
  farlight[i]->light_v[1] = 0;
  farlight[i]->light_v[2] = 1;

  FindMat( X, Y, Z, temp );
  MatVecMult( temp, farlight[i]->light_v, vtemp );
  for( j=0; j<3; j++ ) farlight[i]->light_v[j] = vtemp[j];

  farlight[i]->color[0] = red;
  farlight[i]->color[1] = green;
  farlight[i]->color[2] = blue;

  NumfarLights++;
  return(i);
}

int TepServices::AddptLight( double x, double y, double z,
			 float red, float green, float blue )
{
  int i = NumptLights;

  ptlight[i] = new PTLIGHT;

  // Setup object variables

  ptlight[i]->pos_v[0] = x;
  ptlight[i]->pos_v[1] = y;
  ptlight[i]->pos_v[2] = z;

  ptlight[i]->color[0] = red;
  ptlight[i]->color[1] = green;
  ptlight[i]->color[2] = blue;

  NumptLights++;
  return(i);
}


void TepServices::RemovefarLight(int i)
{
  if(farlight[i] == NULL) return;

  delete farlight[i];		// should set objects[i]=NULL

  farlight[i] = farlight[NumfarLights-1];
  farlight[NumfarLights-1] = NULL;  
  NumfarLights--;
}

void TepServices::RemoveptLight(int i)
{
  if(ptlight[i] == NULL) return;

  delete ptlight[i];		// should set objects[i]=NULL

  ptlight[i] = ptlight[NumfarLights-1];
  ptlight[NumfarLights-1] = NULL;  
  NumptLights--;
}


///////////////////////////////////////////////////////////////////


float TepServices::FindInvCos( float adj, float opp )
{  
  float invcos;

  __asm__ (

    "flds %1 ;"
    "fmuls %1 ;"
    "flds %2 ;"
    "fmuls %2 ;"
    "faddp %%st(1) ;"
    "fsqrt ;"			// There's the hypotenuse...
    "flds %1 ;"
    "fdivrp %%st(1) ;"		// Divide adj by hyp, store in st1 
    "fstps %0"

  :"=m" (invcos)
  :"m" (adj),
   "m" (opp));			// All memory operands

  return invcos;
}

void TepServices::FindScreenAngles(void)
{
  SI->tanXRight = (float)SI->screenX - (float)SI->offsetX;
  SI->invcosXRight = FindInvCos( (float)SI->screenD, SI->tanXRight );  
  SI->tanXRight = SI->tanXRight / (float)SI->screenD;

  SI->tanXLeft = (float)SI->offsetX / (float)SI->screenD;
  SI->invcosXLeft = FindInvCos( (float)SI->screenD, (float)SI->offsetX );

  SI->tanYUp = (float)SI->offsetY / (float)SI->screenD;
  SI->invcosYUp = FindInvCos( (float)SI->screenD, (float)SI->offsetY );

  SI->tanYDown = (float)SI->screenY - (float)SI->offsetY;
  SI->invcosYDown = FindInvCos( (float)SI->screenD, SI->tanYDown );
  SI->tanYDown = SI->tanYDown / (float)SI->screenD;
}

void TepServices::SinCos()
{
  int temp = degrees/2;

  __asm__ __volatile__ (

    "movl %2, %%edi ;"
    "movl %0, %%eax ;"
    "movl %1, %%ebx ;"
    "movl $0, %%edx ;"
    "fld1 ;"
    "fldz ;"
    "movl (%%edi), %%ecx ;"
    "shll $1, %%ecx ;"

    "gen_loop: ;"
    "fldpi ;"
    "fidivl (%%edi) ;"
    "fmul %%st(1) ;"
    "fsincos ;"
    "fstps (%%eax,%%edx) ;"
    "fstps (%%ebx,%%edx) ;"
    "fadd %%st(1) ;"
    "addl $4, %%edx ;"
    "subl $1, %%ecx ;" 
    "jnz gen_loop ;"

    "fcompp "

    :
    :"rm" (&cost[0]),
     "rm" (&sint[0]),
     "rm" (&temp)
    :"%eax", "%ebx", "%ecx", "%edx", "%edi", "%cc" );
}

void TepServices::FindMat( int X, int Y, int Z, Matrix m1 )
{
  m1[0] = cost[Y]*cost[Z];
  m1[1] = -cost[Y]*sint[Z];
  m1[2] = -sint[Y];
  m1[3] = sint[X]*sint[Y]*cost[Z] + cost[X]*sint[Z]; 
  m1[4] = -sint[X]*sint[Y]*sint[Z] + cost[X]*cost[Z];
  m1[5] = sint[X]*cost[Y];
  m1[6] = cost[X]*sint[Y]*cost[Z] - sint[X]*sint[Z];
  m1[7] = -cost[X]*sint[Y]*sint[Z] - sint[X]*cost[Z];
  m1[8] = cost[X]*cost[Y];
}

