#include "tepcore.h"

void TepSound::Init() //Sound intialization
{

    digisound=DIGI_NONE;
    ini.ReadKey ("Tep","Sound",S(inibuf));
    if(stricmp("None",S(inibuf))==0) digisound=DIGI_NONE;
    if(stricmp("Auto",S(inibuf))==0) digisound=DIGI_AUTODETECT;
    if(stricmp("SB",S(inibuf))==0) digisound=DIGI_SB;
    if(stricmp("SB10",S(inibuf))==0) digisound=DIGI_SB10;
    if(stricmp("SB15",S(inibuf))==0) digisound=DIGI_SB15;
    if(stricmp("SB20",S(inibuf))==0) digisound=DIGI_SB20;
    if(stricmp("SBPro",S(inibuf))==0) digisound=DIGI_SBPRO;
    if(stricmp("SB16",S(inibuf))==0) digisound=DIGI_SB16;

    midisound=MIDI_NONE;
    ini.ReadKey ("Tep","MIDI",S(inibuf));
    if(stricmp("None",S(inibuf))==0) midisound=MIDI_NONE;
    if(stricmp("Auto",S(inibuf))==0) midisound=MIDI_AUTODETECT;
    if(stricmp("ADLIB",S(inibuf))==0) midisound=MIDI_ADLIB;
    if(stricmp("OPL2",S(inibuf))==0) midisound=MIDI_OPL2;
    if(stricmp("2XOPL2",S(inibuf))==0) midisound=MIDI_2XOPL2;
    if(stricmp("OPL3",S(inibuf))==0) midisound=MIDI_OPL3;
    if(stricmp("MPU",S(inibuf))==0) midisound=MIDI_MPU;

    if(install_sound(digisound,midisound,NULL) == -1) {cprintf("Problem installing sound! Error: %s. Exiting...\n\r",allegro_error);exit(0);} else cprintf("\rSound module installed...\n\r");
    music=NULL; //Nothing to play (yet)
}

void TepSound::Cleanup()
{
 NoBackgroundMusic();
}

void TepSound::BackgroundMusic()
{
 NoBackgroundMusic(); //It will check for existence itself.
 if (midisound!=MIDI_NONE)
 {
    music = load_midi("mid1.mid");             // Load midi
    play_midi(music,TRUE);                      // Play it! Hmm...I thing we need looping (MX)
 }
}

void TepSound::NoBackgroundMusic()
{
 if (music) //If playing MIDI
 {
  stop_midi();                                  // Stop the midi file
  destroy_midi(music);                          // Kill it
 }
}
