#include "tepcore.h"
#include "tepinln.h"

#define RET { printf("Error at line %d\n",__LINE__); return; }


OBJECT::OBJECT(char *fname)
{
  FILE *f;  
  char str[256];
  int i,j;
  float max;

  f=fopen(fname,"rt");
  if (f==NULL) return;

  while(strcmp(str,"Tri-mesh,")) fscanf(f,"%s",str);
  fscanf(f,"%s",str);
  if (strcmp(str,"Vertices:")) RET;
  fscanf(f,"%d",&NumPoints);
  fscanf(f,"%s",str);
  if (strcmp(str,"Faces:")) RET;
  fscanf(f,"%d",&NumPolys);
  fscanf(f,"%s",str);
  if (strcmp(str,"Max:")) RET;
  fscanf(f,"%f",&max);

  // Create point & poly arrays...

  BasePoints = new POINT[NumPoints];
  BasePolys = new POLY[NumPolys];

  // Now copy the points...

  while(strcmp(str,"Vertex")) fscanf(f,"%s",str);
  fscanf(f,"%s",str);
  if (strcmp(str,"list:")) RET;
  for (i=0; i < NumPoints; i++) {
    fscanf(f,"%s",str);
    if (strcmp(str,"Vertex")) RET;
    fscanf(f,"%s",str); sscanf(str,"%d",&j); if (i-j) RET;
    fscanf(f,"%s",str); sscanf(str,"X:%f", &((BasePoints+i)->pos_v[0]) );
    fscanf(f,"%s",str); sscanf(str,"Y:%f", &((BasePoints+i)->pos_v[1]) );
    fscanf(f,"%s",str); sscanf(str,"Z:%f", &((BasePoints+i)->pos_v[2]) );
//    fscanf(f,"%s",str); // U
//    fscanf(f,"%s",str); // V		Texture coords?
  }

  // And now the polygons...

  while(strcmp(str,"Face")) fscanf(f,"%s",str);
  fscanf(f,"%s",str);
  if (strcmp(str,"list:")) RET;
  for (i=0; i < NumPolys; i++) {
    fscanf(f,"%s",str);
    if (strcmp(str,"Face")) RET;
    fscanf(f,"%s",str); sscanf(str,"%d",&j); if (i-j) RET;
    fscanf(f,"%s",str); sscanf(str,"A:%d",&j); 
		(BasePolys+i)->point[0] = BasePoints + j;
    fscanf(f,"%s",str); sscanf(str,"B:%d",&j); 
		(BasePolys+i)->point[1] = BasePoints + j;
    fscanf(f,"%s",str); sscanf(str,"C:%d",&j); 
		(BasePolys+i)->point[2] = BasePoints + j;
    (BasePolys+i)->point[3] = NULL;

    fscanf(f,"%s",str); // AB
    fscanf(f,"%s",str); // BC
    fscanf(f,"%s",str); // CA
/*    
    fscanf(f,"%s",str);
    if (strcmp(str,"AB:1")) {
	sscanf(str,"D:%d",&j);
	(BasePolys+i)->point[3] = BasePoints + j;
	fscanf(f,"%s",str); // AB
    	fscanf(f,"%s",str); // BC
    	fscanf(f,"%s",str); // CD
    	fscanf(f,"%s",str); // DA
    }
    else {
	(BasePolys+i)->point[3] = NULL;
    	fscanf(f,"%s",str); // BC
    	fscanf(f,"%s",str); // CA
    }  
*/
    // Initialise other polygon stuff    

    (BasePolys+i)->basecolor = 63488+3;
    (BasePolys+i)->reflect = 0.5;
    (BasePolys+i)->ambient = 0.5;
    FindNormal( (BasePolys+i)->point[0]->pos_v, (BasePolys+i)->point[1]->pos_v,
	(BasePolys+i)->point[2]->pos_v, (BasePolys+i)->normal_v );    

  }
  fclose(f);
  type = 1;
}

OBJECT::~OBJECT()
{
  delete[] BasePoints;
  delete[] BasePolys;
  type = 0;
}