#include "tepcore.h"

void TepInput::Init() //Input devices
{
    if(install_keyboard() == -1) {cprintf("Problem installing keyboard! Exiting...\n\r");exit(0);} else cprintf("Keyboard module installed...\n\r");
    clear_keybuf();         // Clear keyboard buffer
    if(install_mouse() == -1) {cprintf("Mouse needed! Exiting...\n\r");exit(0);} else cprintf("Mouse found, module installed...\n\r");


        // Install joystick.
    ini.ReadKey ("Tep","Joystick",S(inibuf));
    if (!(stricmp  ("Yes",S(inibuf))))
    {
        cprintf ("Joystick enabled.\n\r");
        if ((load_joystick_data ("joystick.cal"))!=0 )//Loads calibration data (if present)
        {
            cprintf ("Center your joystick and press any key to continue\n\r");
            readkey();
            if (initialise_joystick()==0)
            {
                cprintf ("\rMove your joystick to top left extreme of its movement and press any key\n\r");
                readkey();
                calibrate_joystick_tl();
                cprintf ("\rMove your joystick to bottom right extreme of its movement and press any key\n\r");
                readkey();
                calibrate_joystick_br();
                save_joystick_data ("joystick.cal");
            }
            else cprintf ("\rJoystick not found! Please run configuration utility and disable it...\n\r");
        }
        else cprintf ("Joystick Initialized\n\r");
    }
}

void TepInput::Cleanup()
{
}
