//**********************************************************
//
//	Inline functions for 3d graphics & flight engines
//
//**********************************************************


inline void FindNormal( Vector v1, Vector v2, Vector v3, Vector res )
{
  int i;
  float temp;
  float* ptr = &temp;
  
  res[0] = (v2[1]-v1[1]) * (v3[2]-v1[2]) - (v2[2]-v1[2]) * (v3[1]-v1[1]);
  res[1] = (v2[2]-v1[2]) * (v3[0]-v1[0]) - (v2[0]-v1[0]) * (v3[2]-v1[2]);
  res[2] = (v2[0]-v1[0]) * (v3[1]-v1[1]) - (v2[1]-v1[1]) * (v3[0]-v1[0]);

  temp = 1 / (res[0]*res[0] + res[1]*res[1] + res[2]*res[2]);
  __asm__ ( "flds (%0) ; fsqrt ; fstps (%0)" : "=r" (ptr) : "r" (ptr) );

  for(i=0; i<3; i++ ) res[i] *= temp;
}



inline void MatMatMult( Matrix m1, Matrix m2, Matrix res )
{
  int i;
  for( i=0; i<3; i++, res+=3, m1+=3 ) {
	res[0] = m1[0]*m2[0]+m1[1]*m2[3]+m1[2]*m2[6];
  	res[1] = m1[0]*m2[1]+m1[1]*m2[4]+m1[2]*m2[7];
  	res[2] = m1[0]*m2[2]+m1[1]*m2[5]+m1[2]*m2[8];
  }
}

inline void MatTMatMult( Matrix m1, Matrix m2, Matrix res )
{
  int i;
  for( i=0; i<3; i++, res+=3, m1+=1 ) {
	res[0] = m1[0]*m2[0]+m1[3]*m2[3]+m1[6]*m2[6];
  	res[1] = m1[0]*m2[1]+m1[3]*m2[4]+m1[6]*m2[7];
  	res[2] = m1[0]*m2[2]+m1[3]*m2[5]+m1[6]*m2[8];
  }
}

inline void MatVecMult( Matrix m1, Vector v1, Vector res )
{
  res[0] = m1[0]*v1[0]+m1[1]*v1[1]+m1[2]*v1[2];
  res[1] = m1[3]*v1[0]+m1[4]*v1[1]+m1[5]*v1[2];
  res[2] = m1[6]*v1[0]+m1[7]*v1[1]+m1[8]*v1[2];
}

inline void MatTVecMult( Matrix m1, Vector v1, Vector res )
{
  res[0] = m1[0]*v1[0]+m1[3]*v1[1]+m1[6]*v1[2];
  res[1] = m1[1]*v1[0]+m1[4]*v1[1]+m1[7]*v1[2];
  res[2] = m1[2]*v1[0]+m1[5]*v1[1]+m1[8]*v1[2];
}

inline void VecSub( Vector v1, Vector v2, Vector res )
{
  res[0] = v1[0]-v2[0];
  res[1] = v1[1]-v2[1];
  res[2] = v1[2]-v2[2];
}

inline void VecAdd( Vector v1, Vector v2, Vector res )
{
  res[0] = v1[0]+v2[0];
  res[1] = v1[1]+v2[1];
  res[2] = v1[2]+v2[2];
}

inline float DotProduct( Vector v1, Vector v2 )
{
  return( v1[0]*v2[0] + v1[1]*v2[1] + v1[2]*v2[2] );
}



