//**********************************************************
//
//	Inline functions for 3d graphics engine only
//
//**********************************************************


inline float CrossProduct( Vector v1, Vector v2, Vector v3 )
{
  int i;
  float tempf[5] = {0,0,0,0,0};

  for( i=0; i<3; i++ ) {
	tempf[0] += -v1[i]*v3[i];	// a.c
  	tempf[1] += v2[i]*v3[i];	// b.c
	tempf[2] += v1[i]*v1[i];	// a.a
	tempf[3] += -v1[i]*v2[i];	// a.b
	tempf[4] += v2[i]*v2[i];	// b.b
  }
  return( tempf[0]*tempf[0]*tempf[4] - 2*tempf[3]*tempf[1]*tempf[0]
		+ tempf[2]*tempf[1]*tempf[1] );
}

inline int ObjectViewTest( float radius, Vector v1 )
{

  // Kill z+r<0 objects

  if( v1[2] + radius < 0) {
	if( radius*radius < v1[0]*v1[0] + v1[2]*v1[2] )
		return(0);
	if( radius*radius < v1[1]*v1[1] + v1[2]*v1[2] )
		return(0);
	return(-1);
	}

  // Kill off other screen objects
	
  if( v1[0] > v1[2]*SI->tanXRight + radius*SI->invcosXRight ) return(0);
  if( v1[0] < -v1[2]*SI->tanXLeft - radius*SI->invcosXLeft ) return(0);

  if( v1[1] > v1[2]*SI->tanYUp + radius*SI->invcosYUp ) return(0);
  if( v1[1] < -v1[2]*SI->tanYDown - radius*SI->invcosYDown ) return(0);

  return(-1);

}

inline void PointViewTest( Vector v1, int* result )
{
  int flags = 0;

  if ( v1[2] <= 0 ) {
	if ( v1[0] < 0 ) flags += 1;
	else flags += 2;
	if ( v1[1] < 0 ) flags += 4;	
	else flags += 8;
	*result = flags;
	return;
	}

  if ( v1[0] > v1[2]*SI->tanXLeft ) flags += 1;
  if ( v1[0] < -v1[2]*SI->tanXRight ) flags += 2;		

  if ( v1[1] > v1[2]*SI->tanYDown ) flags += 4;
  if ( v1[1] < -v1[2]*SI->tanYUp ) flags += 8;

  *result = flags;
}  


inline void DrawPoly
	( VERTEX_2D *lptr, VERTEX_2D *rptr, int low_y, unsigned short color )
{
  int i, cur_y, mult_y, l_xpos, r_xpos, l_step, r_step;
  
//  unsigned int dcolor = (unsigned int)color + ((unsigned int)color << 16);
  cur_y = -lptr->y_2d;
  mult_y = cur_y * SI->scanwidth;
  l_step = lptr->step;
  r_step = rptr->step;
  l_xpos = lptr->x_2d << 16;
  r_xpos = rptr->x_2d << 16;

  while( cur_y < SI->screenY ) {

	l_xpos -= l_step;
	r_xpos -= r_step;	
/*
  	for( i=0; (i+1) < (r_xpos-l_xpos); i+=131072 ) 
		*(int *)((SI->buffer)+mult_y+((l_xpos+i)>>16)) = dcolor;

	if( i<(r_xpos-l_xpos) ) *((SI->buffer)+mult_y+((l_xpos+i)>>16)) = color;
*/
	for( i=0; i < (r_xpos-l_xpos); i+=65536 ) 
		*((SI->buffer)+mult_y+((l_xpos+i)>>16)) = color;


	cur_y++;
	mult_y += SI->scanwidth;

	if( cur_y == -low_y ) break;

	if( cur_y == -(lptr+1)->y_2d ) {
		lptr++;
		l_step = lptr->step;
		l_xpos = lptr->x_2d << 16;
		} 
	
	if( cur_y == -(rptr+1)->y_2d ) {
		rptr++;
		r_step = rptr->step;
		r_xpos = rptr->x_2d << 16;
		} 	
	}

  return;
}

