
#define pk __attribute__ ((packed))

typedef struct SCREENDATA 
{
  int		vbeMode;		// VBE mode number
  int   	screenX;		// width of screen
  int		screenY;		// height of screen
  int		bits;			// bits per pixel
  int		depth;			// bytes per pixel
  int		lfb;			// lfb segment descriptor
  short*	lfbptr;			// Possible pointer to lfb
  int		granularity;		// Value to increment window for VBE 1.2
  int		scanwidth;		// scan width in pixels
  int		bytewidth;  		// scan width in bytes
  int		screenSize;		// total screen frame size in bytes
  int		screenStatus;		// Active screen - 0 or 1
  int		screenStart;
  short*	buffer;			// Memory buffer

  int		screenD;		// distance to screen in pixels
  int		offsetX;
  int		offsetY;		// X & Y offset for centre of screen

  float		tanXRight;
  float		tanXLeft;
  float		tanYUp;
  float		tanYDown;
  float		invcosXRight;
  float		invcosXLeft;
  float		invcosYUp;
  float		invcosYDown;	

} SCREENDATA;  


class TepGraph 
{
private:
  int Xres, Yres;

public:
  void Init();			// Initializes
  void Cleanup();		// Cleanup - back to text mode
  void GoGraph();		// Set screen mode, create buffer

  void BlitBuffer();		// Blit buffer to screen
  void BlitClearBuffer();	// Blit buffer and clear to black
  void ClearBuffer(short);	// Clear screen using short color (5.6.5)
 
  SCREENDATA *ScreenInfo;	// Pointer for accessing screen info

};




