#include "tepcore.h"	// Gets stdio.h eventually...
#include "vesa.h"

int printModes(VBEINFO *vbeInfo)
{
  VBEMODEINFO *vbemodeinfo;
  int i;
  int total = 0;
  unsigned short *modeptr;

  printf("Mode list:\n\n");
 
  modeptr = vbeInfo->VideoModePtr;

  do {	
	vbemodeinfo = vbeGetModeInfo((int)*modeptr);
	i = (int)vbemodeinfo;			
	if( i >= 0 && i < 20 ) printf("Failed to get mode info. Error code = %d \n", i );
 	if( vbemodeinfo->BitsPerPixel == 16 && vbemodeinfo->GreenMaskSize == 6 ) { 
		total++;
		printf("Mode %x  Xres=%i  Yres=%i  BPP=%i  R:G:B = %d:%d:%d \n",
			*modeptr, vbemodeinfo->XResolution, vbemodeinfo->YResolution,
			vbemodeinfo->BitsPerPixel, vbemodeinfo->RedMaskSize,
			vbemodeinfo->GreenMaskSize, vbemodeinfo->BlueMaskSize );	
	}
	modeptr++;

  } while ((*modeptr) != 65535 );

  printf("\nTotal number of 16 bit video modes: %i\n", total );

  return(total);
		
}


void TepGraph::Init() 	//Change resolution, too!
{
  VBEINFO *vbeInfo;

  int i,error;
  long Xpos,Ypos;
  char inputstring[6];

  // Detect the VBE bios

  vbeInfo = vbeDetect();
  i = (int)vbeInfo;

  if( i >= 0 && i < 20 ) {
	switch (i) {
	case 0: printf("Error 0: Failed on DosMemOpen \n"); break;
	case 1: printf("Error 1: Failed on simulate RM int \n"); break;
	case 2: printf("Error 2: Not VBE \n"); break;
	case 3: printf("Error 3: Probably not VBE \n"); break;
	case 4: printf("Error 4: Failed on segment to descriptor \n"); break;
	case 5: printf("Error 5: Too many modes! \n"); break;
	default: printf("Failed to detect vesa bios extensions. Error code %d\n", i ); 
   	}
	exit(0); 
  }

  // Print basic VBE info

  printf("\nVBE Version      : %d.%d\n"
	 "Total memory     : %gK\n",
	  vbeInfo->VbeVersion >> 8,
	  vbeInfo->VbeVersion & 0xFF,
	  ((float)vbeInfo->TotalMemory*64000.0f)/1000.0f);

  i = printModes(vbeInfo);

  printf("Input X resolution:   \n");
  scanf("%s", inputstring); sscanf(inputstring, "%d", &Xres);
  
  printf("Input Y resolution:   \n");
  scanf("%s", inputstring); sscanf(inputstring, "%d", &Yres);

}


void TepGraph::GoGraph()
{
  int i;

  // Go to graphics mode.

  printf("Attempting to set graphics mode %i*%i*16...\n\n", Xres, Yres, 16 );  
  
  ScreenInfo = vbeOpen(Xres,Yres,16);	// Set for 16 bit color
  i = (int)ScreenInfo;

  if( i >= 0 && i < 20) {
	vbeClose();
	switch (i) {
	case 0: printf("Error 0: Failed on DosMemOpen (DPMI) \n"); break;
	case 6: printf("Error 6: vbeInfo not initialised \n"); break;
	case 7: printf("Error 7: Failed on real mode int (DPMI) \n"); break;
	case 9:	break;	// vbeSurface already open
	case 10: printf("Error 10: No matching mode found \n"); break;
	case 11: printf("Error 11: VBE 1.2 windowing not adequately supported \n"); break;
	case 12: printf("Error 12: Failed to map physical address \n"); break;
	case 13: printf("Error 13: Failed to create lfb selector \n"); break;
	case 14: printf("Error 14: Failed to set selector base \n"); break;
	case 15: printf("Error 15: Failed to set selector limit \n"); break;
	case 16: printf("Error 16: Failed to open VBE 1.2 mode \n"); break;
	case 17: printf("Error 17: Failed on segment to descriptor \n"); break;
	default: printf("Failed on vbeOpen. Error code %i \n", i );
	}
	exit(0);
  }	

  // Create memory buffer
  
  if( ScreenInfo->buffer != NULL ) delete[] ScreenInfo->buffer;
  ScreenInfo->buffer = new short[ScreenInfo->scanwidth * ScreenInfo->screenY];
  if( ScreenInfo->buffer == NULL ) { printf("Not enough memory!\n"); exit(0);}

  ScreenInfo->screenSize = ScreenInfo->bytewidth * ScreenInfo->screenY;
  if(ScreenInfo->granularity != 0 ) ScreenInfo->granularity = 
	64 / ScreenInfo->granularity; 

  // And clear it

  ClearBuffer(63203);
  BlitBuffer();
  readkey();
}


void TepGraph::Cleanup()
{
  vbeClose();		// Go back to text mode
}


void TepGraph::BlitClearBuffer()
{
  TEP.Clock.work_fps++;
  vbeBlit();
}


void TepGraph::ClearBuffer(short color)
{

  __asm__ __volatile__ (

    "movl %0, %%edi ;"
    "movl %1, %%ecx ;"		// Iterations = screenSize / 4
    "shrl $2, %%ecx ;"

    "movw %2, %%ax ;"		// Copy colour to top part of eax
    "shll $16, %%eax ;"
    "addw %2, %%ax ;"

    "cld ;"
    "rep ;"
    "stosl "	

    :					// No outputs
    :"m" (ScreenInfo->buffer),		// vbeSurface->lfb for straight to screen
     "m" (ScreenInfo->screenSize),
     "rm" (color)
    : "%edi", "%ecx", "%eax", "%cc" );

}

void TepGraph::BlitBuffer()
{
  int i = SI->screenSize;
  TEP.Clock.work_fps++;
  if( ScreenInfo->lfbptr != 0 ) {

  __asm__ __volatile__ (

    "movl %0, %%esi ;"		// Load esi with buffer pointer
    "movl $0, %%edi ;"		// Load edi with screen pointer
    "movw %%es, %%ax ;"
    "push %%eax ;"
    "movl %1, %%eax ;"
    "movw %%ax, %%es ;"		// Load es with lfb descriptor
    "movl %2, %%ecx ;"		// Load ecx with screen size
    "shrl $2, %%ecx ;"    	// Four bytes copied per repetition

    "cld ;"
    "rep ;"
    "movsl ;"

    "pop %%eax ;"
    "movw %%ax, %%es ;"

    :					// No outputs
    :"m" (ScreenInfo->buffer),
     "m" (ScreenInfo->lfb),
     "m" (i)
    : "%esi", "%edi", "%ecx", "%eax", "%cc" );

  }

  else {

  i = SI->screenSize;

  __asm__ __volatile__ (


    "movl $0x4F05, %%eax ;"
    "movl $0, %%ebx ;"
    "movl $0, %%edx ;"
    ".byte 0xCD ;"
    ".byte 0x10 ;"		// Position zero

    "movw %%es, %%bx ;"
    "push %%ebx ;" 

    "movl %0, %%eax ;"
    "movl %1, %%esi ;"		// Load esi with buffer pointer
    "movw %%ax, %%es ;"		// Load es with lfb descriptor

    "mov %2, %%ecx ;"
    "mov %%ecx, %%eax ;"
    "and $0xffff, %%ecx ;"
    "shrl $2, %%ecx ;"
    "push %%ecx ;"
    "shrl $16, %%eax ;"		// no. of full screens in ebx
    "cld ;"

   
    "loop: ;"

    "movl $0, %%edi ;"
    "movl $16384, %%ecx ;"	// ecx counts down over segment
    "rep ;"
    "movsl ;"

    "push %%eax ;"
    "movl $0x4F05, %%eax ;"
    "movl $0, %%ebx ;"
    "addl $1, %%edx ;"
    ".byte 0xCD ;"
    ".byte 0x10 ;"		// Position 
    "pop %%eax ;"

    "subl $1, %%eax ;"
    "jnz loop ;"

    "pop %%ecx ;"
    "movl $0, %%edi ;"
    "rep ;"
    "movsl ;"

    "pop %%ebx ;"
    "movw %%bx, %%es "

    :					// No outputs
    :"m" (SI->lfb), "m" (SI->buffer), "m" (i),
     "m" (SI->granularity)
    : "%esi", "%edi", "%ebp", "%edx", "%ecx", "%ebx", "%eax", "%cc" );

  }

}

/*		**********************************

  if( ScreenInfo->lfbptr != 0 ) {

  __asm__ __volatile__ (

    "movl %0, %%esi ;"		// Load esi with buffer pointer
    "movl $0, %%edi ;"		// Load edi with screen pointer

    "movw %%es, %%ax ;"
    "push %%eax ;"		// Save es
    "movl %1, %%eax ;"		
    "movw %%ax, %%es ;"		// Load es with lfb selector

    "movl %2, %%edx ;"		// Load ecx with screen size
    "shrl $2, %%edx ;"    	// Four bytes copied per repetition
    "cld ;"
    "movl $0, %%eax ;"		// eax = color value

    "outerloop: ;"		// Blitting bit	

	"movl $256, %%ecx ;"
    	"rep ;"
    	"movsl ;"
    	"subl $1024, %%esi ;"
	"movl $256, %%ecx ;"
    
	"innerloop: ;"		// Buffer clearing bit
    
		"movl %%eax, (%%esi) ;"
    		"movl %%eax, 4(%%esi) ;"
    		"movl %%eax, 8(%%esi) ;"
    		"movl %%eax, 12(%%esi) ;"
    		"movl %%eax, 16(%%esi) ;"
    		"movl %%eax, 20(%%esi) ;"
    		"movl %%eax, 24(%%esi) ;"
    		"movl %%eax, 28(%%esi) ;"
    		"addl $32, %%esi ;"
    		"subl $8, %%ecx ;"
    		"jnz innerloop ;"

    	"subl $256 , %%edx ;"
    	"jnz outerloop ;"

    "pop %%eax ;"
    "movw %%ax, %%es ;"		// restore es

    :					// No outputs
    :"m" (ScreenInfo->buffer),
     "m" (ScreenInfo->lfb),
     "m" (i)
    : "%esi", "%edi", "%ecx", "%edx", "%eax", "%cc" );

  }

  else vbeBlit();

  __asm__ __volatile__ (


    "movl $0x4F05, %%eax ;"
    "movl $0, %%ebx ;"
    "movl $0, %%edx ;"
    ".byte 0xCD ;"
    ".byte 0x10 ;"		// Window A position zero

    "movw %%es, %%bx ;"
    "push %%ebx ;" 		// Save es

    "movl %1, %%esi ;"		// Load esi with buffer pointer
    "movl %0, %%eax ;"
    "movw %%ax, %%es ;"		// Load es with window selector
    "cld ;"			

    "mov %2, %%ecx ;"		
    "mov %%ecx, %%eax ;"	// Screen size in bytes in eax & ecx 	
    "and $0xffff, %%ecx ;"	// 
    "shrl $2, %%ecx ;"		
    "push %%ecx ;"		// Store remaining dwords
    "shrl $16, %%eax ;"		// no. of full screens in eax

   
    "loop3: ;"		// Done once per 64K window

    	"movl $0, %%edi ;"
    	"movl $16384, %%ebx ;"	// ebx counts down dwords over segment
        "push %%eax ;"
        "movl $0, %%eax ;"

    	"outerloop2: ;"		// Blitting bit	

    		"movl $256, %%ecx ;"	// Groups of 256 dwords
    		"rep ;"
    		"movsl ;"
    		"subl $1024, %%esi ;"	
		"movl $256, %%ecx ;"

		"innerloop2: ;"		// Buffer clearing bit

                        "movl %%eax, (%%esi) ;"
                        "movl %%eax, 4(%%esi) ;"
                        "movl %%eax, 8(%%esi) ;"
                        "movl %%eax, 12(%%esi) ;"
                        "movl %%eax, 16(%%esi) ;"
                        "movl %%eax, 20(%%esi) ;"
                        "movl %%eax, 24(%%esi) ;"
                        "movl %%eax, 28(%%esi) ;"
    			"addl $32, %%esi ;"
    			"subl $8, %%ecx ;"
    			"jnz innerloop2 ;"

    		"subl $256, %%ebx ;"
    		"jnz outerloop2 ;"

    	"movl $0x4F05, %%eax ;"
    	"movl $0, %%ebx ;"
        "addl %3, %%edx ;"      // Add granularity
    	".byte 0xCD ;"
    	".byte 0x10 ;"		// Move window A position on by 64K 

        "pop %%eax ;"
    	"subl $1, %%eax ;"
	"jnz loop3 ;"


    "pop %%ebx ;"		// remaining bytes to do in ebx
    "movl $0, %%edi ;"
    
    "outerloop3: ;"

        "movl $0, %%eax ;"
	"movl $256, %%ecx ;"	// Do 256 dwords at a time again
    	"rep ;"
    	"movsl ;"
    	"subl $1024, %%esi ;"
	"movl $256, %%ecx ;"
    	
	"innerloop3: ;"
    	
                "movl %%eax, (%%esi) ;"
                "movl %%eax, 4(%%esi) ;"
                "movl %%eax, 8(%%esi) ;"
                "movl %%eax, 12(%%esi) ;"
                "movl %%eax, 16(%%esi) ;"
                "movl %%eax, 20(%%esi) ;"
                "movl %%eax, 24(%%esi) ;"
                "movl %%eax, 28(%%esi) ;"
    		"addl $32, %%esi ;"
    		"subl $8, %%ecx ;"
   		"jnz innerloop3 ;"

    	"subl $256 , %%ebx ;"
    	"jnz outerloop3 ;"

    "pop %%ebx ;"
    "movw %%bx, %%es "

    :					// No outputs
    :"m" (SI->lfb), "m" (SI->buffer), "m" (i),
     "m" (j)
    : "%esi", "%edi", "%ebp", "%edx", "%ecx", "%ebx", "%eax", "%cc" );

  }
*/
