#include "tepcore.h"
WIniFile ini ("tep.ini");   // .INI file
char inibuf[128];           // .INI file buffer

void TepSystem::Start()
{
 Splash();
 cout<<"Initializing...\n\n";
        // Check for .INI file
 if (ini.IsLoaded()==0)
    {
        cprintf ("Unable to open initialization file. Please run configuration utility. 
		\n\r ^^^^What configuration utility? (JJ) \n\r");
        exit(0);
    }


 CoreInit();
 Graph.Init(); //Don't go to graph mode yet...
 Clock.Init();
 Input.Init();
 Sound.Init();
 Services.Init();

 cout<<"Press any key to continue\n";
 readkey ();	// Just for now, so we can see messages. Services will be initialized here.
 Graph.GoGraph();
 Services.PostGraphInit ();
 Game.Start(); 	// Start the game
}

void TepSystem::Splash() //Introductionary text
{
    clrscr();               // Clear screen before any text

    textcolor(15);cprintf ("The Elite Project %s for %s\n\r",TEP_VER,TEP_PLATFORM);
    textcolor (RED);cprintf ("Warning! Programmers release only. This is work in progress.\n\rSome of the functionality of previous version may not be yet available\n\r");
    textcolor(14);cprintf ("This game is written with DJGPP v2, NASM 0.96 and Allegro 2.2\n\r");
}

void TepSystem::ExitMessage() 	//Say Bye (bye)!
{
 cout <<"Hope you enjoyed this version of TEP. Maybe one day we'll get it finished...\n"
	<<"I was going to put something witty here, but I didn't."
	<<"\n\n Frames per second = "<< TEP.Clock.fps;
}

//Initialization routines should only do one-time hardware intialization
//The actuall services will be provided through classes

void TepSystem::LoopOp()	//Anythong that should be called during every main game loop cycle
{
  Clock.LoopOp();
}

void TepSystem::CoreInit() //The initilization that must be done first
{
    allegro_init();         // Init Allegro game library
    textcolor(7); cprintf ("Allegro initialized\n\r");

        // Look for Windows
    if(windows_version!=0)  // Check for windows
    {
        if (windows_version==256) //Allegro return this code for NT
            cprintf ("Windows NT found - you're screwed matey.\n\n\r");
        else
            cprintf ("Windows found. Version %i.%i\n\n\r",
		windows_version,windows_sub_version);
    }
    else cprintf ("Dos found.\n\n\r"); // Found Dos
    if(install_timer() == -1) {cprintf("Problem installing timer! Exiting...\n\r");
	exit(0);} else cprintf("Timer module installed...\n\r");
}

void TepSystem::CoreCleanup ()
{
 //Nothing to do for Allegro.
}

void TepSystem::Stop()
{
 Services.Cleanup();
 Graph.Cleanup();
 Sound.Cleanup();
 Input.Cleanup();
 Clock.Cleanup();
 CoreCleanup();
 ExitMessage();		// Meay have to move for different systems
}
