//*****************************************************
//
//	Header file for 3d engine routines
//
//*****************************************************

#define pk __attribute__ ((packed))

typedef float Vector[3];
typedef double DVector[3];

typedef float Matrix[9];


class POINT
{
 public:

  Vector	pos_v;	// relative to object orientation
  Vector	rel_v;
  int		x_2d;
  int		y_2d;		// screen coords
};

class POLY
{
 public:

  POINT*	point[4];		// pointer to point
  int		line[4];		// Line numbers
  POINT*	cpoint[6];	// 6 points max for clipping along two planes
  int		cline[6];	// For non-duplication of stepvalues

  unsigned short	basecolor;
  unsigned short	color;
  float		reflect;
  float		ambient;

  float		added_z;
  Vector        normal_v;		// for light sourcing
  Vector	rel_v; 			// relative to global coords  
};

class OBJECT
{
 public:

  // Constructor/destructor:

  OBJECT(char*);
  ~OBJECT();

  // Object data

  int		type;
  float		radius;		
  float		radius_2;
  int		NumPoints;
  int		NumPolys;
  POINT*	BasePoints;
  POLY*		BasePolys;		

  // Global coords

  DVector	pos_v;
  DVector	vel_v;
  Matrix	glob_m;		// floating point dwords for object angle
  Matrix	angvel_m;

  // Relative to camera coords

  Vector	rel_v;
  Vector	normal_v;	// normalised version of rel_v
  Matrix	rel_m;
};

class FARLIGHT
{
 public:

  Vector	light_v;
  float		color[3];
};

class PTLIGHT
{
 public:

  DVector	pos_v;
  Vector	rel_v;
  float		color[3];
};

class CAMERA
{
 public:

  DVector	pos_v;
  Matrix	cam_m;
};

typedef struct VERTEX_2D
{
  int x_2d;
  int y_2d;
  int step;		// stepvalue * 2^16
};


