//*****************************************************
//
//	Main part of 3d engine
//
//*****************************************************

#include "tepcore.h"
#include "tepinln.h"
#include "tepinl3d.h"


void printmat( Matrix m1 )
{
  printf("Matrix: %f,%f,%f,%f,%f,%f,%f,%f,%f \n", m1[0], m1[1], m1[2],
	m1[3], m1[4], m1[5], m1[6], m1[7], m1[8] );
}



void TepServices::Draw3dScene(void)
{
  static POINT* pointptr1, pointptr2;
  static POLY* polyptr1;
  static int i,j,k,l,m;
  static float color[3];

  static OBJECT* obj_sortlist[100];
  static POLY* poly_sortlist[1000];
  static POINT cpoints[1000];

  static int high_y, low_y;
  static VERTEX_2D vertexlist[12], left[4], right[4];

  
  float tempf1[NumfarLights];
  float tempf2[NumptLights];
  float* ptr = &tempf1[0];
  int NumVisObj = 0;
  VERTEX_2D *vertexptr = &vertexlist[0];
  VERTEX_2D *leftptr = &left[0];
  VERTEX_2D *rightptr = &right[0];


  for( i=0 ; i < NumObjects; i++ ) {
	
	// Transform object vector to camera space

	object[i]->rel_v[0] = (float)(object[i]->pos_v[0] - camera.pos_v[0]); 
	object[i]->rel_v[1] = (float)(object[i]->pos_v[1] - camera.pos_v[1]);
	object[i]->rel_v[2] = (float)(object[i]->pos_v[2] - camera.pos_v[2]);
	
	MatTVecMult( camera.cam_m, object[i]->rel_v, object[i]->rel_v );
/*
	printf("Object %d: relX=%f, relY=%f, relZ=%f \n", i,
		object[i]->rel_v[0], object[i]->rel_v[1], object[i]->rel_v[2] ); 
*/
	// Check whether object is within viewscreen.
	// If yes, transform orientation matrix to camera coords
	// and insert by bubble sort into pointer list.
	// If no, ignore.
			
	if( (j = ObjectViewTest( object[i]->radius, object[i]->rel_v )) != 0) {
		
		MatTMatMult( camera.cam_m, object[i]->glob_m,					
			    object[i]->rel_m );

		tempf1[0] = DotProduct( object[i]->rel_v, object[i]->rel_v );
		__asm__ ( "flds (%0); fsqrt; fstps (%1)"
			 : "=r" (ptr) : "r" (ptr) );
		tempf1[0] = 1 / tempf1[0];
		for( k=0; k<3; k++ ) object[i]->normal_v[k] =
			 object[i]->rel_v[k] * tempf1[0];

		j = NumVisObj;		
		if (NumVisObj == 0) { 
			obj_sortlist[j] = object[i];
			NumVisObj++;
			continue;
		}
		while ( obj_sortlist[j-1]->rel_v[2] > object[i]->rel_v[2] ) {	
			obj_sortlist[j] = obj_sortlist[j-1];
			j--;						
		}	
		obj_sortlist[j] = object[i];	
		NumVisObj++;
	
		
	}
  }

  // Now we have the loop for visible objects

  for ( i=0; i < NumVisObj ; i++ ) {

	// Transform points; store in temp part	

	pointptr1 = obj_sortlist[i]->BasePoints;
	
	for( j=0; j < obj_sortlist[i]->NumPoints; j++ ) {

		MatVecMult( obj_sortlist[i]->rel_m,
			pointptr1->pos_v,
			pointptr1->rel_v );
		
		VecAdd( pointptr1->rel_v,
			obj_sortlist[i]->rel_v,
			pointptr1->rel_v );

		// Check points for Xout/Yout:

		PointViewTest( pointptr1->rel_v, &pointptr1->x_2d );
		pointptr1++;
	}				

   	// ****Clip polys by left/right screen planes; 

	// ****store new points in cpoints[]

	// ****Sort polys using painter's algorithm

	// **Perspective transform points

	pointptr1 = obj_sortlist[i]->BasePoints;

	for( j = 0 ; j < obj_sortlist[i]->NumPoints; j++ ) {

		tempf1[0] = ((float)SI->screenD / pointptr1->rel_v[2]);

		pointptr1->x_2d = (int)(pointptr1->rel_v[0] * tempf1[0]) + SI->offsetX;	
		pointptr1->y_2d = (int)(pointptr1->rel_v[1] * tempf1[0]) - SI->offsetY;
/*
		printf("Point %d: %f,%f,%f,%d,%d \n", j, pointptr1->rel_v[0],
			pointptr1->rel_v[1], pointptr1->rel_v[2], 
			pointptr1->x_2d, pointptr1->y_2d );
*/
		pointptr1++;
	}

	// **Find stepvalues and line draw order
	// **Draw polys in turn.


	polyptr1 = obj_sortlist[i]->BasePolys;

	for( j = 0 ; j < obj_sortlist[i]->NumPolys; j++, polyptr1++ ) {

		// Backface removal

		if( ((polyptr1->point[1])->y_2d-(polyptr1->point[0])->y_2d) *
			((polyptr1->point[2])->x_2d-(polyptr1->point[0])->x_2d) <=
			((polyptr1->point[1])->x_2d-(polyptr1->point[0])->x_2d) *
			((polyptr1->point[2])->y_2d-(polyptr1->point[0])->y_2d) )
			continue;

		// Find min/max values of y for polygon

		l=0; while( polyptr1->point[l] != NULL && l != 4 ) l++;	l--;

		high_y = (polyptr1->point[0])->y_2d;
		low_y = high_y;

		for( k=1; k<l+1; k++ ) {
		
			if ((polyptr1->point[k])->y_2d > high_y)
				high_y = (polyptr1->point[k])->y_2d;
			
			else if ((polyptr1->point[k])->y_2d < low_y)
				low_y = (polyptr1->point[k])->y_2d;
			}
		
		// Eliminate polys above and below the screen

		if( low_y == high_y ) continue;
		if( low_y > 0 || -high_y > SI->screenY ) continue;



		// Find 3d normal of poly, do colour conversion using dot product
		
		MatVecMult( obj_sortlist[i]->rel_m,
			polyptr1->normal_v,
			polyptr1->rel_v );

		color[0] = 0; color[1] = 0; color[2] = 0;

		//  Find dot products of lights to poly normals
		
		for( m=0; m<NumfarLights; m++ ) {
			tempf1[m] = -DotProduct( polyptr1->rel_v,
				 farlight[m]->light_v );
			if( tempf1[m] < 0 ) tempf1[m] = 0;
		}

		//  Find ambient colour levels

		for( k=0; k<3; k++ ) {
			for( m=0; m<NumfarLights; m++ ) { 
				color[k] += farlight[m]->color[k] * tempf1[m]
					* polyptr1->ambient;
 		 	}				
		}

		// Check reflectivity, do cross product of light to poly,
		// dot product of camera to point1 of poly		
		
		if( polyptr1->reflect != 0 ) {
			for( m=0; m<NumfarLights; m++ ) {
				if( tempf1[m] == 0 ) continue;
				tempf2[m] = 1 + (DotProduct( polyptr1->rel_v,
					object[i]->normal_v ) + tempf1[k]);
				tempf2[m] *= CrossProduct( polyptr1->rel_v,
					object[i]->normal_v,
					farlight[k]->light_v ); 
			}
			for( k=0; k<3; k++ ) {
				for( m=0; m<NumfarLights; m++ ) { 
					color[k] += farlight[m]->color[k] 
						* tempf2[m] * polyptr1->reflect;
				}
			}				
		}
		
		for( k=0; k<3; k++ ) if( color[k] > 1 ) color[k] = 1;
				
		polyptr1->color = (short)((float)(polyptr1->basecolor & 31)
			* color[0]) & 31;
		polyptr1->color += (short)((float)(polyptr1->basecolor & 2016)
			* color[1]) & 2016;
		polyptr1->color += (short)((float)(polyptr1->basecolor & 63488)
			* color[2]) & 63488;


/*		
		printf("Polygon %d dot product = %f, lightred = %f,
			basecolor = %i, color = %i \n", j, tempf1[0],
			farlight[0]->color[0], polyptr1->basecolor, polyptr1->color );
*/
		// Generate data needed to render polygon
		
		for( k=0; k<(l+1); k++ ) {

			vertexlist[k].x_2d = vertexlist[k+l+1].x_2d 
				= (polyptr1->point[k])->x_2d;

			vertexlist[k].y_2d = vertexlist[k+l+1].y_2d 
				= (polyptr1->point[k])->y_2d;
		}
/*
		printf("low_y = %d, high_y = %d \n", low_y, high_y );
*/
		vertexptr = &vertexlist[0];		
		while( vertexptr->y_2d != high_y ) vertexptr++;
		while( (vertexptr+1)->y_2d == high_y ) vertexptr++;		

		rightptr = &right[0];
		while( vertexptr->y_2d > low_y ) {
			rightptr->y_2d = vertexptr->y_2d;
			rightptr->x_2d = vertexptr->x_2d; 
			vertexptr++;
			rightptr++;
		}
		rightptr->y_2d = vertexptr->y_2d;
		rightptr->x_2d = vertexptr->x_2d; 

		rightptr = &right[0];
		while( rightptr->y_2d > low_y ) {
			rightptr->step = (((rightptr+1)->x_2d - rightptr->x_2d) << 16) 
			/ ((rightptr+1)->y_2d - rightptr->y_2d);	
			rightptr++;
		}	
/*
		for( k=0; k<4; k++ ) printf("Right%i x_2d=%i, y_2d=%i, step=%d \n", k,
				right[k].x_2d, right[k].y_2d, right[k].step );
*/
	
		vertexptr = &vertexlist[(2*l)+1];
		while( vertexptr->y_2d != high_y ) vertexptr--;
		while( (vertexptr-1)->y_2d == high_y ) vertexptr--;		

		leftptr = &left[0];
		while( vertexptr->y_2d > low_y ) {
			leftptr->y_2d = vertexptr->y_2d;
			leftptr->x_2d = vertexptr->x_2d; 
			vertexptr--;
			leftptr++;
		}
		leftptr->y_2d = vertexptr->y_2d;
		leftptr->x_2d = vertexptr->x_2d;

		leftptr = &left[0];
		while( leftptr->y_2d > low_y ) {
			leftptr->step = (((leftptr+1)->x_2d - leftptr->x_2d) << 16) 
			/ ((leftptr+1)->y_2d - leftptr->y_2d);	
			leftptr++;
		}
/*
		for( k=0; k<4; k++ ) printf("Left%i x_2d=%i, y_2d=%i, step=%d \n", k,
				left[k].x_2d, left[k].y_2d, left[k].step );
*/

		// And now we shall draw the polygon...
	
		DrawPoly( &left[0], &right[0], low_y, polyptr1->color );
	}
		
  }  

  return;
}

